<?php

function woofood_format_address($street, $number, $country = null)
{
  $exceptional_countries = array("KR", "ES", "GR", "AT", "SE");

  if(!empty($country))
  {
    if(in_array($country, $exceptional_countries))
    {
      return $street." ".$number;

    }
    else
    {
            return $number." ".$street;

    }

  }
  else
  {
                return $number." ".$street;

  }

}

function woofood_get_order_types()
{
      $order_types = array('delivery'=>esc_html__('Delivery', 'woofood-plugin'), 'pickup'=>esc_html__('Pickup', 'woofood-plugin'));

        return apply_filters( 'woofood_order_types_filter', $order_types);

}

function woofood_get_default_order_type()
{
        $default_order_type = "delivery";

        return apply_filters( 'woofood_default_order_type_filter', $default_order_type);

}

function woofood_get_order_type_by_key($key)
{
        $order_types = woofood_get_order_types();
        if(array_key_exists($key, $order_types))
        {
          return $order_types[$key];
        }

        return "";

}


function woofood_get_minutes_format($return_key = false)
{
  $minutes_format = array(
"default" => "'",
"mins" => esc_html__('mins', 'woofood-plugin'),
"minutes" => esc_html__('minutes', 'woofood-plugin')

  );
  $options_woofood = get_option('woofood_options');
  $woofood_minutes_display_format = isset($options_woofood["woofood_minutes_display_format"]) ? $options_woofood["woofood_minutes_display_format"] : null;

  if($woofood_minutes_display_format)
  {
    if($return_key)
{
      return $options_woofood["woofood_minutes_display_format"];

}
    return $minutes_format[$options_woofood["woofood_minutes_display_format"]];

  }
  else
  {
    if($return_key)
{
      return "default";

}
        return $minutes_format["default"];

  }

}


function woofood_core_is_enabled()
{
  return apply_filters("woofood_core_functionality_enabled", true);
 // return true;
}

?>