<?php
/*
Plugin Name: Mediaspot-Zopyron
Plugin URI: https://mediaspot.gr
Description: Mediaspot Theme
Text Domain: mediaspot-Zopyron
Version: 2.14.1
Author: mediaspot
Author URI: https://mediaspot.gr
*/
defined('ABSPATH') or die;

$mediaspot_zopyron_plugin_data = get_file_data(
    __FILE__,
    array('Version' => 'Version')
);
$name_plugin_np = 'Mediaspot-Zopyron';
require_once dirname(__FILE__) . '/importer/np-check-name.php';
global $wpdb;
$nptablename = $wpdb->prefix . 'pin';
$name_in_table_bd = $wpdb->get_var("SELECT records FROM ". $nptablename);
$folder_name = $wpdb->get_var("SELECT folder FROM ". $nptablename);

if (!file_exists(ABSPATH . 'wp-content/plugins/' . $folder_name) OR $name_in_table_bd == null OR strtolower($name_in_table_bd) == strtolower($name_plugin_np)) {
    register_activation_hook(__FILE__, 'NpImportNotice::resetImportNotice');
    register_activation_hook(__FILE__, 'NpImport::activation');
    $wpdb->query('TRUNCATE TABLE ' . $nptablename);
    $wpdb->insert($nptablename, array('records' => 'Mediaspot-Zopyron', 'folder' => 'mediaspot_zopyron'));

    define('APP_PLUGIN_URL', plugin_dir_url(__FILE__));
    define('APP_PLUGIN_PATH', plugin_dir_path(__FILE__));
    define('APP_PLUGIN_VERSION', $mediaspot_zopyron_plugin_data['Version']);
    define('APP_PLUGIN_WIZARD_NAME', 'Plugin Wizard');

    include_once dirname(__FILE__) . '/functions.php';
    include_once dirname(__FILE__) . '/editor/class-np-editor.php';
    include_once dirname(__FILE__) . '/importer/class-np-import.php';
    include_once dirname(__FILE__) . '/includes/class-np-settings.php';
    
    register_deactivation_hook(__FILE__, 'NpImportNotice::addImportNoticeOption');
    register_deactivation_hook(__FILE__, 'NpImportNotice::removePluginDatabaseTable');
    register_deactivation_hook(__FILE__, 'NpImportNotice::restartThemeImportContent');
} else {
    if ($name_plugin_np != $name_in_table_bd) {
        add_action('admin_init', 'same_plugin_off');
        /**
         * Same plugin off
         */
        function same_plugin_off() {
            deactivate_plugins(plugin_basename(__FILE__));
        }
        add_action('admin_notices', 'same_plugin_error_notice');
        /**
         * Same plugin notice
         */
        function same_plugin_error_notice(){
            $name_plugin_np = 'Mediaspot-Zopyron';
            global $wpdb;
            $name_in_table_bd = $wpdb->get_var("SELECT records FROM ".$wpdb->prefix . "pin");
            echo ("<div class=\"error\"><p>Unable to activate <strong>".$name_plugin_np."</strong> plugin, because plugin <strong>".$name_in_table_bd."</strong> is already activated. Please deactivate <strong>".$name_in_table_bd."</strong> first.</p></div>");
        }
    }
}

require ABSPATH . WPINC . '/pluggable.php';
if (!get_option('headerNp') && !get_option('footerNp')) {
    $currentDir = dirname(__FILE__);
    if (file_exists($currentDir . '/content/content.json')) {
        $import = new NpContentImporter($currentDir . '/content');
        $import->setHeaderFooterImagesPlaceHolders();
        $import->importImages();
        $import->importParameters(true);
    }
}